/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.udf;

import CH.ifa.draw.figures.ImageFigure;
import CH.ifa.draw.figures.RectangleFigure;
import CH.ifa.draw.framework.ConnectionFigure;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.PointConstrainer;
import CH.ifa.draw.standard.CompositeFigure;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import DE.siemens.ad.logo.app.Application;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.ConstantBlock;
import DE.siemens.ad.logo.model.block.AnalogInputBlock;
import DE.siemens.ad.logo.model.block.AnalogOutputBlock;
import DE.siemens.ad.logo.model.block.InputBlock;
import DE.siemens.ad.logo.model.block.OutputBlock;
import DE.siemens.ad.logo.util.Util;
import DE.siemens.ad.pdraw.app.LogoComfort;
import DE.siemens.ad.pdraw.figures.BlockFigure;
import DE.siemens.ad.pdraw.figures.BlockTextFigure;
import DE.siemens.ad.pdraw.figures.InputIfcFigure;
import DE.siemens.ad.pdraw.figures.OutputIfcFigure;
import DE.siemens.ad.pdraw.figures.ParameterTextFigure;
import DE.siemens.ad.pdraw.figures.PrintImageFigure;
import DE.siemens.ad.pdraw.figures.constraints.ConnectorConstraint;
import DE.siemens.ad.pdraw.figures.constraints.FigureConstraint;
import DE.siemens.ad.pdraw.figures.constraints.MiniBlockConstraint;
import DE.siemens.ad.pdraw.standard.LogoConnectionGridConstrainer;
import DE.siemens.ad.pdraw.standard.LogoDrawing;
import DE.siemens.ad.pdraw.standard.LogoGridConstrainer;
import DE.siemens.ad.udf.EditUDFConstraint;
import DE.siemens.ad.udf.LogoDrawingUDF;
import DE.siemens.ad.udf.ResizeHandles;
import DE.siemens.ad.udf.ResizeUDFBoxHandles;
import DE.siemens.ad.udf.UDFBoxFigure;
import DE.siemens.ad.udf.UDFLeftConnectorFigure;
import DE.siemens.ad.udf.UDFRightConnectorFigure;
import DE.siemens.ad.udf.WiringDiagramUDF;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditUDFFigure
extends CompositeFigure {
    private static final long serialVersionUID = -2688407225237883830L;
    private WiringDiagramUDF fUDF_WD = null;
    private int miniFigureWidth = 12;
    private int miniFigureHeight = 6;
    private int defaultUDFBoxBorderSize = 30;
    private int defaultUDFBoxWidth = 640;
    private int defaultUDFBoxHeight = 480;
    private BlockTextFigure blockTextFigure;
    protected transient ResizeHandles fResizeHandles = null;
    private RectangleFigure udfContainer = new UDFBoxFigure(new Point(this.defaultUDFBoxBorderSize, this.defaultUDFBoxBorderSize), new Point(this.defaultUDFBoxBorderSize + this.defaultUDFBoxWidth, this.defaultUDFBoxBorderSize + this.defaultUDFBoxHeight));
    private Vector<BlockFigure> fInputfigures;
    private Vector<BlockFigure> fOutputfigures;
    protected UDFLeftConnectorFigure udfLeftConnectorFigure;
    protected UDFRightConnectorFigure udfRightConnectorFigure;

    public EditUDFFigure(WiringDiagramUDF model, Point p) {
        this.fUDF_WD = model;
        this.initComponents();
        this.moveTo(p);
    }

    public EditUDFFigure() {
    }

    public Figure findFigure(int x, int y) {
        if (this.blockTextFigure != null && this.blockTextFigure.displayBox().contains(x, y)) {
            return this;
        }
        FigureEnumeration k = this.figuresReverse();
        while (k.hasMoreElements()) {
            Figure figure = k.nextFigure();
            if (!figure.containsPoint(x, y)) continue;
            return figure;
        }
        return null;
    }

    protected void initComponents() {
        this.addEditBorder();
        this.addBlockTextFigure();
        this.addUDFIOFigures();
        this.addUDFConnectorFigure();
        this.layout();
    }

    public UDFLeftConnectorFigure getUDFLeftConnectorFigure() {
        return this.udfLeftConnectorFigure;
    }

    public UDFRightConnectorFigure getUDFRightConnectorFigure() {
        return this.udfRightConnectorFigure;
    }

    public int getMiniFigureHeight() {
        return this.miniFigureHeight;
    }

    public int getMiniFigureWidth() {
        return this.miniFigureWidth;
    }

    public void addUDFConnectorFigure() {
        int width = ((UDFBoxFigure)this.udfContainer).getStrokeWidth();
        if (this.udfLeftConnectorFigure == null) {
            this.udfLeftConnectorFigure = new UDFLeftConnectorFigure();
            this.udfLeftConnectorFigure.basicDisplayBox(new Rectangle(this.getEditArea().x - width, this.getEditArea().y, width * 2, this.getEditArea().height));
        }
        if (this.udfRightConnectorFigure == null) {
            this.udfRightConnectorFigure = new UDFRightConnectorFigure();
            this.udfRightConnectorFigure.basicDisplayBox(new Rectangle(this.getEditArea().x - width, this.getEditArea().y, width * 2, this.getEditArea().height));
        }
        this.add(this.udfLeftConnectorFigure);
        this.add(this.udfRightConnectorFigure);
    }

    @Override
    public void basicDisplayBox(Point origin, Point corner) {
        this.layout();
    }

    @Override
    public void invalidate() {
        super.invalidate();
    }

    protected void addBlockTextFigure() {
        this.blockTextFigure = new BlockTextFigure();
        this.blockTextFigure.setAttribute("FontSize", 18);
        this.blockTextFigure.setAttribute("FontStyle", 1);
        String blockName = this.fUDF_WD.getUDFBlock().getIdentifier();
        this.blockTextFigure.setText(blockName);
        this.add(this.blockTextFigure);
    }

    private void addUDFIOFigures() {
        this.fInputfigures = new Vector();
        this.fOutputfigures = new Vector();
        this.addAll(this.fInputfigures);
        this.addAll(this.fOutputfigures);
    }

    public final MiniBlockFigure handleWizardConnected(Block block, Point point) {
        MiniBlockFigure newWizard = null;
        newWizard = new MiniBlockFigure(block, point);
        if (block.getNumberType() == 6 || block.getNumberType() == 11) {
            this.fUDF_WD.getInConnectorBlocks().add(block);
            this.fUDF_WD.insert(block);
            this.fInputfigures.add(newWizard);
        } else if (block.getNumberType() == 7 || block.getNumberType() == 13) {
            this.fUDF_WD.getOutConnectorBlocks().add(block);
            this.fUDF_WD.insert(block);
            this.fOutputfigures.add(newWizard);
        } else {
            return null;
        }
        this.add(newWizard);
        return newWizard;
    }

    @Override
    public Vector handles() {
        Vector handles = new Vector();
        this.getResizeHandles().addHandles(this.udfContainer, handles, 320, 240);
        return handles;
    }

    protected ResizeHandles getResizeHandles() {
        if (this.fResizeHandles == null) {
            this.fResizeHandles = new ResizeUDFBoxHandles();
        }
        return this.fResizeHandles;
    }

    @Override
    public FigureConstraint createConstraint() {
        return new EditUDFConstraint(this);
    }

    private void addEditBorder() {
        this.add(this.udfContainer);
    }

    protected void layout() {
        Point original;
        Figure figure;
        DrawingView view = null;
        try {
            view = ((LogoComfort)Application.getInstance().getActiveApplicationSurface().getEditor()).view();
        }
        catch (Exception e) {
            // empty catch block
        }
        PointConstrainer c = null;
        if (view != null) {
            c = view.getConstrainer();
        }
        c = c instanceof LogoGridConstrainer && ((LogoGridConstrainer)c).getGridIfc().gridConnectionAttractionIsOn() ? new LogoConnectionGridConstrainer(c) : null;
        Rectangle imageDisplayBox = this.udfContainer.displayBox();
        Iterator<BlockFigure> iter = this.fInputfigures.iterator();
        int x = imageDisplayBox.x;
        this.udfLeftConnectorFigure.basicDisplayBox(new Rectangle(x - this.udfLeftConnectorFigure.displayBox().width / 2, imageDisplayBox.y, this.udfLeftConnectorFigure.displayBox().width, imageDisplayBox.height));
        while (iter.hasNext()) {
            figure = iter.next();
            if (!(figure instanceof BlockFigure)) continue;
            original = ((BlockFigure)figure).getImageFigure().displayBox().getLocation();
            figure.moveBy(x - this.miniFigureWidth / 2 - original.x, 0);
        }
        iter = this.fOutputfigures.iterator();
        x = imageDisplayBox.x + imageDisplayBox.width;
        this.udfRightConnectorFigure.basicDisplayBox(new Rectangle(x - this.udfRightConnectorFigure.displayBox().width / 2, imageDisplayBox.y, this.udfRightConnectorFigure.displayBox().width, imageDisplayBox.height));
        while (iter.hasNext()) {
            figure = iter.next();
            if (!(figure instanceof BlockFigure)) continue;
            original = ((BlockFigure)figure).getImageFigure().displayBox().getLocation();
            figure.moveBy(x - this.miniFigureWidth / 2 - original.x, 0);
        }
        this.updateConnection();
        Point idTextOriginal = this.blockTextFigure.displayBox().getLocation();
        this.blockTextFigure.moveBy(imageDisplayBox.x + (imageDisplayBox.width - this.blockTextFigure.displayBox().width) / 2 - idTextOriginal.x, imageDisplayBox.y - this.blockTextFigure.displayBox().height - 5 - idTextOriginal.y);
        String blockName = this.fUDF_WD.getUDFBlock().getIdentifier();
        this.blockTextFigure.setText(blockName);
    }

    private void updateConnection() {
        if (this.drawing() == null) {
            return;
        }
        FigureEnumeration fe = ((LogoDrawing)this.drawing()).figures();
        ArrayList ifcFigures = new ArrayList();
        while (fe.hasMoreElements()) {
            Figure f = fe.nextFigure();
            if (!(f instanceof BlockFigure)) continue;
            Block blk = ((BlockFigure)f).getBlock();
            if (blk.getClass() == InputBlock.class || blk.getClass() == AnalogInputBlock.class) {
                ifcFigures.addAll(((BlockFigure)f).getOutputIfcFigures());
                continue;
            }
            if (blk.getClass() != OutputBlock.class && blk.getClass() != AnalogOutputBlock.class) continue;
            ifcFigures.addAll(((BlockFigure)f).getInputIfcFigures());
        }
        for (Figure f : ifcFigures) {
            Collection fcList = ((ConnectorConstraint)f.getConstraint()).getConnectionLineConstraints();
            for (FigureConstraint fc : fcList) {
                ((ConnectionFigure)fc.getFigure()).updateConnection();
            }
        }
    }

    public MiniBlockFigure addMiniBlockFigure(Boolean input, Boolean analog, Point point) {
        MiniBlockFigure mini = null;
        EditUDFFigure figure = ((LogoDrawingUDF)this.drawing()).getEditUDFFigure();
        if (figure == null) {
            return mini;
        }
        ConstantBlock block = null;
        block = input.booleanValue() ? (analog.booleanValue() ? new AnalogInputBlock(figure.getWiringDiagramUDF()) : new InputBlock(figure.getWiringDiagramUDF())) : (analog != false ? new AnalogOutputBlock(figure.getWiringDiagramUDF()) : new OutputBlock(figure.getWiringDiagramUDF()));
        mini = this.handleWizardConnected(block, point);
        this.refineLocation();
        return mini;
    }

    public void refineLocation() {
        int in;
        Block block;
        BlockFigure temp;
        int out;
        Vector<BlockFigure> fInputfigures = this.getInputfigures();
        Vector<BlockFigure> fOutputfigures = this.getOutputfigures();
        Vector<Block> inputBlocks = this.fUDF_WD.getInConnectorBlocks();
        Vector<Block> outputBlocks = this.fUDF_WD.getOutConnectorBlocks();
        for (out = 0; out < fInputfigures.size(); ++out) {
            temp = fInputfigures.get(out);
            block = inputBlocks.get(out);
            for (in = out; in > 0 && fInputfigures.get((int)(in - 1)).displayBox().y > temp.displayBox().y; --in) {
                fInputfigures.set(in, fInputfigures.get(in - 1));
                inputBlocks.set(in, inputBlocks.get(in - 1));
            }
            fInputfigures.set(in, temp);
            inputBlocks.set(in, block);
        }
        out = 0;
        for (out = 0; out < fOutputfigures.size(); ++out) {
            temp = fOutputfigures.get(out);
            block = outputBlocks.get(out);
            for (in = out; in > 0 && fOutputfigures.get((int)(in - 1)).displayBox().y > temp.displayBox().y; --in) {
                fOutputfigures.set(in, fOutputfigures.get(in - 1));
                outputBlocks.set(in, outputBlocks.get(in - 1));
            }
            fOutputfigures.set(in, temp);
            outputBlocks.set(in, block);
        }
    }

    @Override
    public Figure removeFromDrawing(Figure figure) {
        this.remove(figure);
        this.layout();
        return null;
    }

    @Override
    public void remove(Figure figure) {
        super.remove(figure);
        if (this.fInputfigures.contains(figure)) {
            figure.deleteObserver(this);
            figure.setContainer(null);
            this.fInputfigures.remove(figure);
            this.fUDF_WD.getInConnectorBlocks().remove(((BlockFigure)figure).getBlock());
        } else if (this.fOutputfigures.contains(figure)) {
            figure.deleteObserver(this);
            figure.setContainer(null);
            this.fOutputfigures.remove(figure);
            this.fUDF_WD.getOutConnectorBlocks().remove(((BlockFigure)figure).getBlock());
        }
    }

    public void setEditArea(Rectangle rect) {
        this.udfContainer.displayBox(rect);
        this.layout();
    }

    public Rectangle getEditArea() {
        return this.udfContainer.displayBox();
    }

    @Override
    public boolean containsPoint(int x, int y) {
        return this.getEditArea().contains(x, y) || this.blockTextFigure.containsPoint(x, y) || this.getUDFLeftConnectorFigure().containsPoint(x, y) || this.getUDFRightConnectorFigure().containsPoint(x, y) || this.getMiniFigureHavePoint(x, y) != null;
    }

    public Figure getMiniFigureHavePoint(int x, int y) {
        int i;
        for (i = 0; i < this.fInputfigures.size(); ++i) {
            boolean inContains = this.fInputfigures.get(i).displayBox().contains(x, y);
            if (!inContains) continue;
            return this.fInputfigures.get(i);
        }
        for (i = 0; i < this.fOutputfigures.size(); ++i) {
            boolean outContains = this.fOutputfigures.get(i).displayBox().contains(x, y);
            if (!outContains) continue;
            return this.fOutputfigures.get(i);
        }
        return null;
    }

    public boolean havePointOnBorder(int x, int y) {
        int margin = ((UDFBoxFigure)this.udfContainer).getStrokeWidth();
        Rectangle inBox = new Rectangle(this.getUDFLeftConnectorFigure().displayBox().x + this.getUDFLeftConnectorFigure().displayBox().width, this.getEditArea().y + margin, this.getUDFRightConnectorFigure().displayBox().x - this.getUDFLeftConnectorFigure().displayBox().x - this.getUDFLeftConnectorFigure().displayBox().width, this.udfContainer.displayBox().height - margin * 2);
        return !inBox.contains(x, y);
    }

    @Override
    public Rectangle displayBox() {
        Rectangle box = null;
        for (Object o : this.fFigures) {
            if (box == null) {
                box = ((Figure)o).displayBox();
                continue;
            }
            box.add(((Figure)o).displayBox());
        }
        return box;
    }

    public WiringDiagramUDF getWiringDiagramUDF() {
        return this.fUDF_WD;
    }

    public BlockTextFigure getIdTextFigure() {
        return this.blockTextFigure;
    }

    public RectangleFigure getUDFBoxFigure() {
        return this.udfContainer;
    }

    @Override
    public void moveBy(int x, int y) {
        super.moveBy(x, y);
        this.layout();
    }

    @Override
    public void read(StorableInput input) {
    }

    @Override
    public void write(StorableOutput output) {
    }

    public Vector<BlockFigure> getInputfigures() {
        return this.fInputfigures;
    }

    public Vector<BlockFigure> getOutputfigures() {
        return this.fOutputfigures;
    }

    public void setWiringDiagram(WiringDiagramUDF wd) {
        this.fUDF_WD = wd;
    }

    public MiniBlockFigure getMiniBlockFigure(Block ioBlock) {
        BlockFigure figure2 = null;
        if (ioBlock.getClass() == InputBlock.class || ioBlock.getClass() == AnalogInputBlock.class) {
            for (BlockFigure figure2 : this.getInputfigures()) {
                if (figure2.getBlock() != ioBlock) continue;
                return (MiniBlockFigure)figure2;
            }
        } else {
            for (BlockFigure figure2 : this.getOutputfigures()) {
                if (figure2.getBlock() != ioBlock) continue;
                return (MiniBlockFigure)figure2;
            }
        }
        return null;
    }

    public class MiniBlockFigure
    extends BlockFigure {
        private static final long serialVersionUID = 3534417907173499552L;

        public MiniBlockFigure(Block block, Point origin) {
            super(block, origin);
        }

        public MiniBlockFigure() {
        }

        public FigureConstraint createConstraint() {
            return new MiniBlockConstraint(this);
        }

        public void setInputName() {
            LogoDrawing drawing = (LogoDrawing)this.drawing();
            if (drawing == null) {
                return;
            }
            String text = this.getBlock().getUserDefinedName();
            if (text != null && text.length() > 0) {
                this.getBlockTextFigure().setText(this.getBlockTextFigure().getText() + "(" + text + ")");
            }
        }

        protected void createBlockFigureComponents() {
            if (this.fBlock == null) {
                return;
            }
            this.addImageFigure();
            if (this.fBlock instanceof InputBlock) {
                this.addOutputFigures();
            } else {
                this.addInputFigures();
            }
            this.addConnectorNameFigure();
            this.addBlockTextFigure();
            this.addParameterTextFigure();
            this.layout();
        }

        protected void addImageFigure() {
            BufferedImage image = new BufferedImage(EditUDFFigure.this.getMiniFigureWidth(), EditUDFFigure.this.getMiniFigureHeight(), 5);
            PrintImageFigure imageFigure = new PrintImageFigure(image, null, new Point(this.fDisplayBox.x, this.fDisplayBox.y)){
                private static final long serialVersionUID = -6067323685071051651L;

                protected void drawGhost(Graphics g, BlockFigure blockFigure) {
                    Color oldColor = g.getColor();
                    Rectangle rect = this.displayBox();
                    if (MiniBlockFigure.this.fBlock.getConnectedBlocks().size() > 0) {
                        g.setColor(Util.getColor("fb.background.color", fImageColor));
                    } else if (MiniBlockFigure.this.getBlock().getClass() == InputBlock.class && !MiniBlockFigure.this.getBlock().getOutConnector(0).isConnectable() || MiniBlockFigure.this.getBlock().getClass() == OutputBlock.class && !MiniBlockFigure.this.getBlock().getInConnector(0).isConnectable()) {
                        g.setColor(Color.GRAY);
                    } else {
                        g.setColor(Color.GREEN);
                    }
                    g.fillRect(rect.x, rect.y, rect.width, rect.height);
                    g.setColor(oldColor);
                }
            };
            this.add(imageFigure, "imageFigureGroup");
        }

        protected void addBlockTextFigure() {
            MiniBlockTextFigure blockTextFigure = new MiniBlockTextFigure();
            String blockName = this.fBlock.getUserDefinedName();
            blockName = blockName == null || blockName.equals("") ? "" : "(" + blockName + ")";
            blockTextFigure.setText(this.fBlock.getNumberString() + blockName);
            if (this.fBlock != null) {
                this.fBlock.addBlockNameChangedListener(this);
            }
            this.add(blockTextFigure, "blockNumberFigureGroup");
        }

        protected void layout() {
            List outConnectorGroup;
            List inConnectorGroup = (List)this.getGroupFiguresMap().get("inConnectorFigureGroup");
            int inputCount = 0;
            if (inConnectorGroup != null) {
                inputCount = inConnectorGroup.size();
            }
            this.layoutImageFigure();
            Rectangle imageBox = this.getImageFigure().displayBox();
            int yPos = imageBox.y + imageBox.height / 2;
            if (inputCount > 0) {
                InputIfcFigure inIfcFigure = (InputIfcFigure)inConnectorGroup.get(0);
                inIfcFigure.setPoints(new Point(imageBox.x - 6, yPos), new Point(imageBox.x, yPos));
                inIfcFigure.getConstraint().move(new Dimension(0, 0));
            }
            if ((outConnectorGroup = (List)this.getGroupFiguresMap().get("outConnectorFigureGroup")) != null && outConnectorGroup.size() > 0) {
                OutputIfcFigure outIfcFigure = (OutputIfcFigure)outConnectorGroup.get(0);
                outIfcFigure.setPoints(new Point(imageBox.x + imageBox.width, yPos), new Point(imageBox.x + imageBox.width + 6, yPos));
            }
            Rectangle textBox = this.getBlockTextFigure().displayBox();
            textBox.setLocation(imageBox.x + (imageBox.width - textBox.width) / 2, imageBox.getLocation().y - textBox.height);
            this.getBlockTextFigure().basicDisplayBox(textBox);
            Rectangle connectorNameDisplayBox = this.fCCFigure.displayBox();
            connectorNameDisplayBox.setLocation(textBox.x + textBox.width, textBox.y);
            this.fCCFigure.basicDisplayBox(connectorNameDisplayBox);
            ParameterTextFigure parameterTextFigure = (ParameterTextFigure)((List)this.getGroupFiguresMap().get("parameterFigureGroup")).get(0);
            Rectangle parameterDisplayBox = parameterTextFigure.displayBox();
            parameterDisplayBox.setLocation(imageBox.getLocation());
            parameterTextFigure.displayBox(parameterDisplayBox);
            if (Application.getInstance().getActiveApplicationSurface().getEditor() != null) {
                DrawingView view = ((LogoComfort)Application.getInstance().getActiveApplicationSurface().getEditor()).view();
                int dy = view.getConstrainer().constrainY((Point)new Point((int)imageBox.x, (int)yPos)).y - yPos;
                this.moveBy(0, dy);
            }
        }

        protected void layoutImageFigure() {
            ImageFigure imageFigure = this.getImageFigure();
            Rectangle imageBox = imageFigure.displayBox();
            imageFigure.basicDisplayBox(imageBox);
        }

        public void moveAlignmentAnchorTo(Point destinationPoint) {
            this.moveBy(0, 0);
        }
    }

    public class MiniBlockTextFigure
    extends BlockTextFigure {
        protected int drawNextLine(Graphics g, FontMetrics metrics, int offset, String text) {
            return super.drawNextLine(g, metrics, offset, "#" + text);
        }
    }
}

